/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "aim.h"

#include "util/loading/load_param.h"
#include "graphics_engine.h"
#include "state.h"
#include "material.h"
#include "t_animation.h"
#include "text.h"

#include "world_entity.h"



ObjectListDefinition(Aim);

/**
 * standart constructor
 */
Aim::Aim (PNode* source, const TiXmlElement* root)
{
  this->init();

  this->source = source;

  if (root)
    this->loadParams(root);
  else
    this->setTexture("textures/aim.png");
}

/**
 * destroys a Aim
*/
Aim::~Aim ()
{
  /*  if (this->text != NULL)
      delete this->text;*/
}

/**
 * initializes the Aim
 */
void Aim::init()
{
  this->registerObject(this, Aim::_objectList);
  this->setName("Aim");

  this->setLayer(E2D_LAYER_TOP);
  this->setRotationSpeed(30.0* (float)rand()/RAND_MAX + 10.0);
  this->setSize(GraphicsEngine::getInstance()->getResolutionX()/10.0);

  this->setBindNode(this);
  this->source = NULL;

  this->range = 1000;
  this->angle = M_PI_4;
  this->targetGroup = OM_GROUP_01;
  this->anim = new tAnimation<Aim>(this, &Aim::setSize);
  this->anim->setInfinity(ANIM_INF_CONSTANT);
  this->anim->addKeyFrame(500, .3, ANIM_LINEAR);
  this->anim->addKeyFrame(100, .2, ANIM_LINEAR);
  this->anim->addKeyFrame(50, .01, ANIM_LINEAR);


  /*  this->text = new Text();
    this->text->setLayer(this->getLayer());
    this->text->setParent2D(this);
    this->text->setRelCoor2D(10, -50);
    this->text->setParentMode2D(E2D_PARENT_MOVEMENT);
    this->text->setText("Testing");*/
}

void Aim::loadParams(const TiXmlElement* root)
{
  PNode::loadParams(root);

  LoadParam(root, "texture", this, Aim, setTexture)
  .describe("the texture-file to load onto the Aim");

  LoadParam(root, "size", this, Aim, setSize)
  .describe("the size of the Aim in Pixels");

  LoadParam(root, "rotation-speed", this, Aim, setRotationSpeed)
  .describe("the Speed with which the Aim should rotate");

  LoadParam(root, "target-group", this, Aim, setTargetGroupS);
}

void Aim::searchTarget()
{
  ObjectManager::EntityList::iterator entity;
  //printf("%d\n", this->targetGroup);
  for (entity = State::getObjectManager()->getEntityList(this->targetGroup).begin();
       entity != State::getObjectManager()->getEntityList(this->targetGroup).end();
       entity ++)
  {
    diffVec = ( (*entity)->getAbsCoor() - this->source->getAbsCoor() );

    if ( diffVec.len() < range )//&&  acos( (this->source->getAbsDirX()).dot(diffVec)/(diffVec.len() * (this->source->getAbsDirX()).len() ) )  < angle)
    {
      //if (this->getParent() != (*entity))
      {
        //        printf("found target::: %d %s::%s\n", (*entity)->getOMListNumber(), (*entity)->getClassCName(), (*entity)->getCName());
        this->anim->replay();
        this->setParentSoft(*entity, 5);
        return;
      }
    }
  }

  //if no target found:
  this->setParent(PNode::getNullParent());
}

void Aim::setTargetGroupS(const std::string& groupName)
{
  OM_LIST id = ObjectManager::StringToOMList(groupName);
  if (id != OM_NULL)
    this->setTargetGroup(id);
  else
    PRINTF(2)("List %s not found for targetting\n", groupName.c_str());
}

/**
 * @brief sets the size of the Aim.
 * @param size the size in pixels
 */
void Aim::setSize(float size)
{
  this->setSize2D(size/2, size/2);
}

/**
 * sets the material to load
 * @param textureFile The texture-file to load onto the crosshair
 */
void Aim::setTexture(const std::string& textureFile)
{
  this->material.setDiffuseMap(textureFile);
}

/**
 * ticks the Aim
 * @param dt the time to ticks
 */
void Aim::tick(float dt)
{
  // let the crosshair rotate
  this->shiftDir2D(dt * rotationSpeed);

  //   char outputText[100];
  //   sprintf(outputText, "%s - distance: %f\n", this->getParent()->getName(), (this->source->getAbsCoor() - this->getAbsCoor()).len());
  //   this->text->setText(outputText);


  //  if (this->source->getAbsCoor().x > this->getAbsCoor().x )
  diffVec = ( this->getAbsCoor() - this->source->getAbsCoor() );
  //only look for target if the aim hasn`t locked a target yet or if the actual target is out of range
  if(this->getParent() == PNode::getNullParent() ||
      diffVec.len() > range )// ||
    //( acos( (this->source->getAbsDirX()).dot(diffVec)/(diffVec.len() * (this->source->getAbsDirX()).len() ) ) > angle))
  {
    this->setParentSoft(PNode::getNullParent(),5);
    this->searchTarget();
  }

  //   float z = 0.0f;
  //   glReadPixels ((int)this->getAbsCoor2D().x,
  //                  GraphicsEngine::getInstance()->getResolutionY()-(int)this->getAbsCoor2D().y-1,
  //                  1,
  //                  1,
  //                  GL_DEPTH_COMPONENT,
  //                  GL_FLOAT,
  //                  &z);
  //
  //
  //   GLdouble objX=.0, objY=.0, objZ=.0;
  //   gluUnProject(this->getAbsCoor2D().x,
  //                GraphicsEngine::getInstance()->getResolutionY()-this->getAbsCoor2D().y-1,
  //                .99,  // z
  //                GraphicsEngine::modMat,
  //                GraphicsEngine::projMat,
  //                GraphicsEngine::viewPort,
  //                &objX,
  //                &objY,
  //                &objZ );
  //aa
  //   this->setAbsCoor(objX, objY, objZ);
}

/**
 * draws the crosshair
 */
void Aim::draw() const
{

  if( this->getParent() != PNode::getNullParent() )
  {
    glPushMatrix();
    glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0);

    glRotatef(this->getAbsDir2D(), 0,0,1);
    this->material.select();
    glBegin(GL_TRIANGLE_STRIP);
    glTexCoord2f(0, 0);
    glVertex2f(-this->getSizeX2D(), -this->getSizeY2D());
    glTexCoord2f(1, 0);
    glVertex2f(this->getSizeX2D(), -this->getSizeY2D());
    glTexCoord2f(0, 1);
    glVertex2f(-this->getSizeX2D(), this->getSizeY2D());
    glTexCoord2f(1, 1);
    glVertex2f(this->getSizeX2D(), this->getSizeY2D());
    glEnd();
    glPopMatrix();
  }

}
