/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "collision_probe.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "md2/md2Model.h"



ObjectListDefinition(CollisionProbe);

CREATE_FACTORY(CollisionProbe);


/**
 *  destructs the spaceship, deletes alocated memory
 */
CollisionProbe::~CollisionProbe ()
{}


/**
 *  creates a new Spaceship from Xml Data
 * @param root the xml element containing spaceship data

   @todo add more parameters to load
*/
CollisionProbe::CollisionProbe(const TiXmlElement* root)
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}


/**
 * initializes a Spaceship
 */
void CollisionProbe::init()
{
  this->registerObject(this, CollisionProbe::_objectList);

  bUp = bDown = bLeft = bRight = bAscend = bDescend = bRollL = bRollR = false;

  this->setHealthMax(100);
  this->setHealth(80);

  this->toList(OM_GROUP_00);
  this->loadMD2Texture("textures/dr_freak.pcx");
  this->loadModel("models/dr_freak.md2");

  this->localVelocity = Vector(0,0,0);
}


/**
 * loads the Settings of a CollisionProbe from an XML-element.
 * @param root the XML-element to load the Spaceship's properties from
 */
void CollisionProbe::loadParams(const TiXmlElement* root)
{
  Playable::loadParams(root);
}



/**
 *  draws the spaceship after transforming it.
*/
void CollisionProbe::draw () const
{
  WorldEntity::draw();
}


/**
 *  the function called for each passing timeSnap
 * @param time The timespan passed since last update
 */
void CollisionProbe::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((MD2Model*)this->getModel(0))->tick(time);

  this->shiftCoor(this->localVelocity * time);
}


/**
 * @todo switch statement ??
 */
void CollisionProbe::process(const Event &event)
{

}




