
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Silvan Nellen
   co-programmer:

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "boomerang_projectile.h"

#include "state.h"

#include "particles/dot_emitter.h"
#include "particles/sprite_particles.h"

#include "debug.h"


ObjectListDefinition(BoomerangProjectile);
CREATE_FAST_FACTORY_STATIC(BoomerangProjectile);

/**
 *  standard constructor
*/
BoomerangProjectile::BoomerangProjectile () : Projectile()
{
  this->registerObject(this, BoomerangProjectile::_objectList);

  this->loadModel("models/projectiles/orx-rocket.obj", 2.0);
  this->loadExplosionSound("sound/explosions/explosion_4.wav");


  this->setMinEnergy(1);
  this->setHealthMax(10);
  this->lifeSpan = 2.0;
  this->agility = 3.5;
  this->maxVelocity = 150;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 *  standard deconstructor
*/
BoomerangProjectile::~BoomerangProjectile ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (BoomerangProjectile::trailParticles != NULL && BoomerangProjectile::objectList().size() <= 1)
  {
    if (ParticleSystem::objectList().exists(BoomerangProjectile::trailParticles))
      delete BoomerangProjectile::trailParticles;
    BoomerangProjectile::trailParticles = NULL;
  }
  if (BoomerangProjectile::explosionParticles != NULL && BoomerangProjectile::objectList().size() <= 1)
  {
    if (ParticleSystem::objectList().exists(BoomerangProjectile::explosionParticles))
      delete BoomerangProjectile::explosionParticles;
    BoomerangProjectile::explosionParticles = NULL;
  }

}

SpriteParticles* BoomerangProjectile::trailParticles = NULL;
SpriteParticles* BoomerangProjectile::explosionParticles = NULL;



void BoomerangProjectile::activate()
{
  if (unlikely(BoomerangProjectile::trailParticles == NULL))
  {
    BoomerangProjectile::trailParticles = new SpriteParticles(2000);
    BoomerangProjectile::trailParticles->setName("BoomerangProjectileTrailParticles");
    BoomerangProjectile::trailParticles->setMaterialTexture("textures/radial-trans-noise.png");
    BoomerangProjectile::trailParticles->setLifeSpan(1.0, .3);
    BoomerangProjectile::trailParticles->setRadius(0.0, .5);
    BoomerangProjectile::trailParticles->setRadius(0.2, 4.0);
    BoomerangProjectile::trailParticles->setRadius(.5, 1.5);
    BoomerangProjectile::trailParticles->setRadius(1.0, 1.5);
    BoomerangProjectile::trailParticles->setColor(0.0, 1,0,0,.7);
    BoomerangProjectile::trailParticles->setColor(0.2, .8,.8,0,.5);
    BoomerangProjectile::trailParticles->setColor(0.5, .8,.8,.8,.8);
    BoomerangProjectile::trailParticles->setColor(1.0, .8,.8,.8,.0);
  }
  if (unlikely(BoomerangProjectile::explosionParticles == NULL))
  {
    BoomerangProjectile::explosionParticles = new SpriteParticles(200);
    BoomerangProjectile::explosionParticles->setName("BoomerangProjectileExplosionParticles");
    BoomerangProjectile::explosionParticles->setMaterialTexture("textures/radial-trans-noise.png");
    BoomerangProjectile::explosionParticles->setLifeSpan(.5, .3);
    BoomerangProjectile::explosionParticles->setRadius(0.0, 10);
    BoomerangProjectile::explosionParticles->setRadius(.5, 15.0);
    BoomerangProjectile::explosionParticles->setRadius(1.0, 10.0);
    BoomerangProjectile::explosionParticles->setColor(0.0, 0,1,0,1);
    BoomerangProjectile::explosionParticles->setColor(0.5, .8,.8,0,.8);
    BoomerangProjectile::explosionParticles->setColor(0.8, .8,.8,.3,.8);
    BoomerangProjectile::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  this->emitter->setSystem(BoomerangProjectile::trailParticles);

  this->updateNode(0);
  this->emitter->setEmissionRate(45.0);
  this->emitter->setEmissionVelocity(0.0);

  this->setHealth(10.0* (float)rand()/(float)RAND_MAX);
}


void BoomerangProjectile::deactivate()
{
  this->emitter->setSystem(NULL);
  this->lifeCycle = 0.0;

  this->toList(OM_DEAD);
  this->removeNode();
  BoomerangProjectile::fastFactory->kill(this);
}


void BoomerangProjectile::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity)
    this->destroy( entity );
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void BoomerangProjectile::tick (float time)
{

  Vector targetFarFarAway = this->getAbsCoor() + Vector(100000, 0, 0);

  {
    speed = velocity.len();
    diffVector = ((targetFarFarAway - this->getAbsCoor()).getNormalized());

    if(velocity.dot(diffVector) != 0)
    {
      correctionVector = (( ( diffVector *  (speed * speed/( velocity.dot(diffVector ) ) )) - velocity).getNormalized()) * agility;

      if( (diffVector *  (speed * speed/( velocity.dot(diffVector ) ) ) -velocity).len() < agility )
        velocity = ((diffVector *  (speed * speed/( velocity.dot(diffVector ) ) )).getNormalized())*agility;
      else if(velocity.dot(diffVector) > 0)
        velocity += correctionVector;
      else if (velocity.dot(diffVector) < 0)
        velocity -= correctionVector;
    }
    else
      velocity += diffVector * agility;

    this->setAbsDir(Quaternion(velocity, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)));
  }

  velocity *= maxVelocity/velocity.len();
  Vector v = this->velocity * (time);
  this->shiftCoor(v);

  if(this->tickLifeCycle(time))
    this->deactivate();
}

/**
 *  the function gets called, when the projectile is destroyed
 */
void BoomerangProjectile::destroy (WorldEntity* killer)
{

  printf("THIS SHOULD WORLk\n");

  Projectile::destroy( killer );
  PRINTF(5)("DESTROY BoomerangProjectile\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
  this->emitter->setSystem(BoomerangProjectile::explosionParticles);

  this->emitter->setEmissionRate(1000.0);
  this->emitter->setEmissionVelocity(50.0);
  //  this->deactivate();

}


void BoomerangProjectile::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->getModel()->draw();

  glPopMatrix();

}

