

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "interactive_model.h"


#include "door.h"


ObjectListDefinition(Door);
CREATE_FACTORY(Door);



//! list of all different animations a std md2model supports
sAnim Door::animationList[2] =
{
 // begin, end, fps, interruptable
  {   0,  15,  30,  0 },   //!< OPEN
  {   15, 29,  30,  0 }    //!< CLOSE
};



Door::Door(const TiXmlElement* root)
{
  this->registerObject(this, Door::_objectList);
  this->scale = 1.0f;
  this->actionRadius = 1.0;

  if( root != NULL)
    this->loadParams(root);

  this->toList(OM_COMMON);
  this->bLocked = false;
  this->bOpen = false;

  this->loadMD2Texture("textures/doors.jpg");
  this->loadModel("models/creatures/doors.md2", this->scale);

  this->setAnimation(DOOR_CLOSE, MD2_ANIM_ONCE);
}


Door::~Door ()
{}



/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void Door::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "action-radius", this, Door, setActionRadius)
      .describe("sets the action radius of the door")
      .defaultValues(3.0);
  LoadParam(root, "scale", this, Door, setScale)
      .describe("sets the scale of the door")
      .defaultValues(1.0);
}


/**
 * sets the animatin of this entity
 */
void  Door::setAnimation(int animNum, int playbackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationList[animNum].firstFrame,
                                                         animationList[animNum].lastFrame,
                                                         animationList[animNum].fps,
                                                         animationList[animNum].bStoppable,
                                                         playbackMode);
}


/**
 * ticks the door
 * @param time: time since last tick
 */
void Door::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->tick(time);

  if( !this->bOpen)
  {
    if( this->checkOpen())
    {
      this->open();
    }
  }
  else
  {
    if( !this->checkOpen())
    {
      this->close();
    }
  }

}


/**
 * open the door
 */
void Door::open()
{
  if( this->bLocked)
    return;

  this->setAnimation(DOOR_OPEN, MD2_ANIM_ONCE);
  this->bOpen = true;
}


/**
 * close the door
 */
void Door::close()
{
  this->setAnimation(DOOR_CLOSE, MD2_ANIM_ONCE);
  this->bOpen = false;
}


#include "playable.h"
#include "generic_npc.h"
/**
 * checks if the door is open
 */
bool Door::checkOpen()
{

  WorldEntity* entity;
  float distance;

  for (ObjectList<Playable>::const_iterator it = Playable::objectList().begin();
       it != Playable::objectList().end();
       ++it)
  // for all players
  {
    entity = (*it);

    distance = fabs((this->getAbsCoor() - entity->getAbsCoor()).len());
    if( distance < this->actionRadius)
      return true;
  }



  for (ObjectList<GenericNPC>::const_iterator it = GenericNPC::objectList().begin();
       it != GenericNPC::objectList().end();
       ++it)
  {
    entity = (*it);

    distance = fabs((this->getAbsCoor() - entity->getAbsCoor()).len());
    if( distance < this->actionRadius)
      return true;
  }

  return false;
}



