/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "glgui_radar.h"
#include "world_entity.h"

#include "debug.h"

namespace OrxGui
{
  /**
   * @brief standard constructor
   */
  GLGuiRadar::GLGuiRadar ()
  {
    this->init();
  }


  /**
   * @brief standard deconstructor
   */
  GLGuiRadar::~GLGuiRadar ()
  {}

  void GLGuiRadar::init()
  {
    this->setBackgroundTexture("textures/gui/gui_radar.png");

    this->_updateInterval = .01f;
    this->_timePassed = 0.0f;
    this->_range = 100.0f;
    this->_centerNode = NULL;
  }

  void GLGuiRadar::setCenterNode(const PNode* center)
  {
    this->_centerNode = center;
  }

  void GLGuiRadar::addEntityList(const std::list<WorldEntity*>* entityList, const Color& color)
  {
    for (unsigned int i = 0; i < this->_dotLists.size(); ++i)
      if (_dotLists[i].entityList == entityList)
        return;

    GLGuiRadar::DotList dotList;
    dotList.dotColor = color;
    dotList.entityList = entityList;

    this->_dotLists.push_back(dotList);
  }

  void GLGuiRadar::removeEntityList(const std::list<WorldEntity*>* entityList)
  {
    std::vector<DotList>::iterator it;
    for (it = this->_dotLists.begin(); it != this->_dotLists.end(); ++it)
      if ((*it).entityList == entityList)
      {
        this->_dotLists.erase(it);
        break;
      }
  }


  void GLGuiRadar::setRange(float range)
  {
    this->_range = range;
  }


  void GLGuiRadar::setAttenuation(Attenuation attenuation)
  {
    this->_attenuation = attenuation;
  }


  void GLGuiRadar::tick(float dt)
  {
    _timePassed+=dt;

    if (_timePassed > _updateInterval)
    {
      _timePassed = 0 ; //-=_updateInterval;
      this->updateRadar();
    }

  }

  void GLGuiRadar::updateRadar()
  {
    if (_centerNode == NULL)
    {
      for (unsigned int i = 0; i < this->_dotLists.size(); ++i)
        this->_dotLists[i].positions.clear();
      return;
    }

    std::list<WorldEntity*>::const_iterator it;
    for (unsigned int i = 0; i < this->_dotLists.size(); ++i)
    {
      this->_dotLists[i].positions.clear();

      for (it = _dotLists[i].entityList->begin(); it != _dotLists[i].entityList->end(); ++it)
      {
        if (_centerNode->distance(*it) < this->_range)
        {
          this->_dotLists[i].positions.push_back(Vector2D(((*it)->getAbsCoor().x - _centerNode->getAbsCoor().x) * this->getSizeX2D() ,
                                                 ((*it)->getAbsCoor().z - _centerNode->getAbsCoor().z) * this->getSizeY2D()  )
                                                 / (2.0f * _range));
        }

      }

    }
  }


  void GLGuiRadar::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    if (likely(this->_centerNode != NULL))
    {
      glTranslatef(this->getSizeX2D()/2.0f, this->getSizeY2D()/2.0f, 0);
      glRotatef((this->_centerNode->getAbsDir().getHeading() - M_PI_2)* 180.0 /M_PI , 0, 0, 1);

      glPointSize(4.0f);
      for (unsigned int i = 0; i < this->_dotLists.size(); ++i)
      {
        glColor4fv(&_dotLists[i].dotColor[0]);
        for (unsigned int j = 0; j < this->_dotLists[i].positions.size(); ++j)
        {
          glBegin(GL_POINTS);
          glVertex2f(this->_dotLists[i].positions[j].x, this->_dotLists[i].positions[j].y);
          glEnd();
        }
      }
    }
    this->endDraw();
  }


  void GLGuiRadar::resize()
  {
    GLGuiWidget::resize();
  }


  void GLGuiRadar::showing()
  {}

  void GLGuiRadar::hiding()
{}}
