/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "glgui_energywidget.h"

#include "multi_type.h"

namespace OrxGui
{
  /**
   * @brief standard constructor
   */
  GLGuiEnergyWidget::GLGuiEnergyWidget ()
  {
    //   this->setClassID(CL_PROTO_ID, "GLGuiEnergyWidget");

    this->_bar.setSize2D(100, 30);
    this->pack(&this->_name);
    this->pack(&this->_valueText);
    this->_bar.setParent2D(&this->_valueText);

    this->_name.setForegroundColor(Color(1,1,1,.8));
    this->_valueText.setChangedTextColor(Color::white);

    //this->setBackgroundTexture("textures/gui/gui_element_background_2.png");
    this->setBackgroundColor(Color(.5,.5,.5,1));

    //this->_name.setBackgroundTexture(Texture());
    //this->_valueText.setBackgroundTexture("textures/gui/gui_element_background_2.png");
    this->_bar.setBackgroundTexture(Texture());
    this->_bar.setBackgroundColor(Color(0,0,0,0));
    this->_bar.setForegroundTexture("textures/gui/gui_element_background_faded.png");
    this->_bar.setForegroundColor(Color(.5, .5, .5, 1));
    this->_bar.setChangedValueColor(Color::black);
  }


  /**
   * @brief standard deconstructor
   */
  GLGuiEnergyWidget::~GLGuiEnergyWidget ()
  {
  }


  void GLGuiEnergyWidget::setDisplayedName(const std::string& name)
  {
    this->_name.setText(name);
    this->_bar.setWidgetSize(this->_name.getSize2D());
  }

  void GLGuiEnergyWidget::setMaximum(float max)
  {
    this->_bar.setMaximum(max);
  }

  void GLGuiEnergyWidget::setValue(float value)
  {
    MultiType val(value);
    val.setType(MT_INT);


    this->_bar.setValue(value);
    this->_bar.setForegroundColor(Color::slerpHSVColor(Color::red, Color::green, value/this->_bar.maximum()));
    this->_bar.setFrontColor(Color(1,1,1,1), true);
    this->_valueText.setText(val.getString());
  }

  void GLGuiEnergyWidget::resize()
  {
    GLGuiBox::resize();
  }


  void GLGuiEnergyWidget::showing()
  {
    this->_name.show();
    this->_valueText.show();
    this->_bar.show();
  }

  void GLGuiEnergyWidget::hiding()
  {
    this->_name.hide();
    this->_valueText.hide();
    this->_bar.hide();
  }
}
