/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON


#include "lightning_bolt.h"

#include "util/loading/factory.h"
#include "material.h"

#include "sound/resource_sound_buffer.h"





ObjectListDefinition(LightningBolt);
CREATE_FACTORY(LightningBolt);

/**
 *  standard constructor
*/
LightningBolt::LightningBolt (const TiXmlElement* root)
{
  this->registerObject(this, LightningBolt::_objectList);

  this->toList(OM_COMMON);

  this->bRender = false;
  this->time = 0.0;
  this->flashFrequency = 0.6f;
  this->flashConstTime = 0.07f;

  this->material = new Material();
  this->material->setDiffuseMap("textures/lightning_bolt.png");
  //this->offset = Vector(-1440.00, 100.00, 280.00);

  this->setAbsCoor(offset);
  this->width = 100.0f;
  this->height = 300.0f;
  this->bNewCoordinate = false;

  this->seedX = 200.f;
  this->seedZ = 500.0f;
  this->seedTime = 4.0f;

  this->soundSource.setSourceNode(this);

  this->thunderBuffer = OrxSound::ResourceSoundBuffer("sounds/atmosphere/thunder.wav");
}


/**
 *  standard deconstructor
*/
LightningBolt::~LightningBolt ()
{
}

void LightningBolt::activate()
{
}


void LightningBolt::deactivate()
{

}


/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void LightningBolt::tick (float dt)
{
  this->time += dt;

  if( this->time > this->flashFrequency)
  {
    this->bRender = true;
    this->time = 0.0f;
    this->soundSource.play(this->thunderBuffer);
  }
  else if( this->bRender && this->time > this->flashConstTime)
  {
    this->bRender = false;
    this->time = 0.0f;
    this->bNewCoordinate = true;
  }

  if( this->bNewCoordinate)
  {
    this->flashFrequency = this->seedTime * (float)rand()/(float)RAND_MAX + 0.1;
    this->setAbsCoor( - 800.0f - this->seedX * (float)rand()/(float)RAND_MAX, 250.00, -200.0f + this->seedZ * (float)rand()/(float)RAND_MAX);
    this->bNewCoordinate = false;
  }
}


void LightningBolt::draw() const
{
  if( this->bRender)
  {

    glPushMatrix();
    glTranslatef (this->getAbsCoor ().x,
                  this->getAbsCoor ().y,
                  this->getAbsCoor ().z);

    glRotatef(90, 0.0f,1.0f,0.0f);

//     Vector tmpRot = drawPart->orientation.getSpacialAxis();
//     glRotatef (drawPart->orientation.getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

//     glPushAttrib(GL_ENABLE_BIT);
//     glDisable(GL_LIGHTING);
//     glDisable(GL_BLEND);

    this->material->select();

    glBegin(GL_QUADS);
    glTexCoord2f(1.0f, 1.0f); glVertex3f(-width/2, -height/2,  0.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex3f( width/2, -height/2,  0.0f);
    glTexCoord2f(0.0f, 0.0f); glVertex3f( width/2,  height/2,  0.0f);
    glTexCoord2f(1.0f, 0.0f); glVertex3f(-width/2,  height/2,  0.0f);
    glEnd();

//     glPopAttrib();

    glPopMatrix();
  }
}


