/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: David Hasenfratz
   co-programmer: ...

   this file extends the framework file, so it renders what i want.
*/

#include "framework.h"

#include "light.h"

#include "material.h"
#include "primitive_model.h"
#include <stdlib.h>

#include "media_container.h"

Model* obj;
Material* testMat;
MediaContainer* media_container;

int counter = 0;
float timer = 0;
float fps;


void Framework::moduleInit(int argc, char** argv)
{
  if( argc <= 1)
  {
    printf("Wrong arguments try following notations:\n");
    printf("./multitex [media_file]\n");
    exit(0);
  }

  media_container = new MediaContainer(argv[1]);

  testMat = new Material;
  testMat->setDiffuseMap("textures/radialTransparency.png");
  obj = new PrimitiveModel(PRIM_PLANE, 10.0);

  LightManager* lightMan = LightManager::getInstance();
  lightMan->setAmbientColor(.1,.1,.1);
  (new Light())->setAbsCoor(5.0, 10.0, 40.0);
  (new Light())->setAbsCoor(-10, -20, -100);

  fps = media_container->getFPS();
}

void Framework::moduleEventHandler(SDL_Event* event)
{
  switch (event->type)
    {
    case SDL_KEYDOWN:
      switch (event->key.keysym.sym)
        {
        case SDLK_1:
          obj = new PrimitiveModel(PRIM_CUBE, 10.0);
          break;
        case SDLK_2:
          obj = new PrimitiveModel(PRIM_SPHERE, 10.0);
          break;
        case SDLK_3:
          obj = new PrimitiveModel(PRIM_PLANE, 10.0);
          break;
        // increase fps
        case SDLK_9:
          fps++;
          PRINTF(0)("fps: %0.2f\n", fps);
          break;
        // decrease fps
        case SDLK_8:
          if(fps > 0)
            fps--;
          PRINTF(0)("fps: %0.2f\n", fps);
          break;
        }
    }
}

void Framework::moduleTick(float dt)
{
  timer += dt;

  if(counter != fps * timer)
  {
    counter = fps * timer;

    if (counter >= media_container->getFrameCount())
    {
      timer = 0;
      counter = 0;
    }
  }
}

void Framework::moduleDraw(void) const
{
  testMat->select();
  glBindTexture(GL_TEXTURE_2D, media_container->getFrameTexture(counter));
  obj->draw();

  LightManager::getInstance()->draw();
}

void Framework::moduleHelp(void) const
{

}
