/*!
 * @file resource_oif.h
 * @brief Contains the ResourceOIF class, that handles the Resource-specific loading part of the OIF.
 *
 */

#ifndef _RESOURCE_OIF_H
#define _RESOURCE_OIF_H

#include "util/loading/resource.h"
#include "object_information_file.h"


class ResourceOIF : public ObjectInformationFile, public Resources::Resource
{
public:
  ResourceOIF(const std::string& fileName,
              const Resources::KeepLevel& keepLevel = Resources::KeepLevel());
  static ResourceOIF createFromString(const std::string& loadString, const Resources::KeepLevel& keepLevel = Resources::KeepLevel());


private:
class OIFResourcePointer : public Resources::StorePointer
  {
  public:
    OIFResourcePointer(const std::string& loadString, const Resources::KeepLevel& keepLevel, const OIFData::Pointer& data);
    inline const OIFData::Pointer& ptr() const { return pointer; }
    virtual bool last() const { return pointer.count() == 1; }
  private:
    OIFData::Pointer pointer;
  };

private:
  static Resources::tType<ResourceOIF> type;
};


#endif /* _RESOURCE_OIF_H */
