/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli patrick@orxonox.net
   co-programmer:
*/

#include "resource_oif.h"

#include "substring.h"
#include "multi_type.h"
#include "debug.h"


ResourceOIF::ResourceOIF(const std::string& fileName, const Resources::KeepLevel& keepLevel)
    : Resource(&ResourceOIF::type)
{
  Resources::StorePointer* ptr = this->acquireResource(fileName);


  if (ptr)
  {
    PRINTF(5)("FOUND OIF: %s\n", fileName.c_str());
    this->acquireData(static_cast<ResourceOIF::OIFResourcePointer*>(ptr)->ptr());
  }
  else
  {
    PRINTF(5)("NOT FOUND OIF: %s\n", fileName.c_str());
    std::string fullName = this->Resource::locateFile(fileName);
    PRINTF(5)("trying loading of: %s\n", fullName.c_str());
    this->load(fullName);
    this->Resource::addResource(new ResourceOIF::OIFResourcePointer(fileName, keepLevel, this->ObjectInformationFile::dataPointer()));
  }

}

ResourceOIF ResourceOIF::createFromString(const std::string& loadString, const Resources::KeepLevel& keepLevel)
{
  SubString loadValues(loadString, ',');
  std::string fileName;
  if (loadValues.size() > 0)
    fileName = loadValues[0];

  return ResourceOIF(fileName);
}



Resources::tType<ResourceOIF> ResourceOIF::type("OIF");





ResourceOIF::OIFResourcePointer::OIFResourcePointer(const std::string& loadString, const Resources::KeepLevel& keepLevel, const OIFData::Pointer& data)
    : Resources::StorePointer(loadString, keepLevel) , pointer(data)
{}


