/*!
 * @file object_information_file.h
 * @brief Definition of a class that helps defining mount point connections
*/

#ifndef _OBJECT_INFORMATION_FILE_H
#define _OBJECT_INFORMATION_FILE_H

#include "base_object.h"

#include "count_pointer.h"


//! A class for object informations
class OIFData : BaseObject
{
public:
  typedef CountPointer<OIFData>    Pointer;


public:
  OIFData();
  OIFData(const std::string& fileName);
  virtual ~OIFData();

  void load(const std::string& fileName);
  void initMountPoint(const TiXmlElement* root);

  inline const TiXmlElement* root() { return this->_root; }


private:
  TiXmlElement* _root;           //!< root of the xml file
};

//! A class for object informations
class ObjectInformationFile : BaseObject
{

public:
  ObjectInformationFile();
  ObjectInformationFile(const ObjectInformationFile& oif);
  ObjectInformationFile(const std::string& fileName);
  virtual ~ObjectInformationFile();

  void load(const std::string& fileName);

  ObjectInformationFile& operator=(const ObjectInformationFile& oif);

  /** @returns a reference to the xml oif file */
  inline const TiXmlElement* getMountPointDescription() { return this->data->root(); }

  inline void acquireData(const OIFData::Pointer& data) { this->data = data; }
  const OIFData::Pointer& dataPointer() const { return this->data; };



  private:
    void init();


private:
  CountPointer<OIFData>          data;                           //!< the oif data pointer

};

#endif /* _OBJECT_INFORMATION_FILE_H */
