/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli patrick@orxonox.net
   co-programmer:
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "object_information_file.h"

#include "resource_oif.h"

#include "util/loading/factory.h"
#include "util/loading/load_param_xml.h"



/**
 * constructor
 */
OIFData::OIFData()
{
  this->_root = NULL;
}


/**
 * constructor
 * @param fileName name of the file
 */
OIFData::OIFData(const std::string& fileName)
{
  this->_root = NULL;
  this->load(fileName);
}


OIFData::~OIFData()
{
  if( this->_root)
    delete this->_root;
}


/**
 * loading the data
 * @param fileName file name where the data can be found
 */
void OIFData::load(const std::string& fileName)
{
  if( fileName.empty())
  {
    PRINTF(1)("No filename specified for object information loading");
    return;
  }

  TiXmlDocument* XMLDoc = new TiXmlDocument(fileName);
  // load the campaign document
  if( !XMLDoc->LoadFile(fileName))
  {
    // report an error
    PRINTF(1)("Could not load XML File %s: %s @ %d:%d\n", fileName.c_str(), XMLDoc->ErrorDesc(), XMLDoc->ErrorRow(), XMLDoc->ErrorCol());
    return;
  }

  // check basic validity
  this->_root = XMLDoc->RootElement();
  assert( this->_root != NULL);

  if( strcmp( this->_root->Value(), "ObjectInformationFile"))
  {
    // report an error
    PRINTF(1)("Specified XML File is not an orxonox object information file (<ObjectInformationFile> element missing)\n");
    return;
  }

//   this->initMountPoint( this->_root);
}


/**
 * constructor
 * @param fileName name of the file
 */
ObjectInformationFile::ObjectInformationFile()
  : data(new OIFData)
{
  this->init();
}

/**
 * constructor
 * @param fileName name of the file
 */
ObjectInformationFile::ObjectInformationFile(const std::string& fileName)
  : data(new OIFData(fileName))
{
  // load the oif file
  this->data = ResourceOIF(fileName).data;

  this->init();
}


/**
 * copy constructor
 * @param oif instance to copy from
*/
ObjectInformationFile::ObjectInformationFile(const ObjectInformationFile& oif)
  :data(oif.data)
{
  this->init();
}


/**
 * the definition of the assignment operator
 * @param oif
 * @return
 */
ObjectInformationFile& ObjectInformationFile::operator=(const ObjectInformationFile& oif)
{
  this->init();
  this->data = oif.data;

  return *this;
}

/**
 * initizlizing function
 */
void ObjectInformationFile::init()
{

}


void ObjectInformationFile::load(const std::string& fileName)
{
  this->data = OIFData::Pointer(new OIFData(fileName));
}


/**
 * standard deconstructor
*/
ObjectInformationFile::~ObjectInformationFile ()
{
  // delete what has to be deleted here
}


/**
 * this initializes the mount point
 * @param mountPoint to be initialized
 */
// void ObjectInformationFile::initMountPoint(MountPoint* mountPoint)
// {
//   TiXmlElement* root = this->data->root();
//
// }

