/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_MODEL

#include "model.h"
#include "debug.h"
#include "glincl.h"

ObjectListDefinition(Model);

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
Model::Model()
{
  this->registerObject(this, Model::_objectList);
  this->pModelInfo.numVertices = 0;
  this->pModelInfo.numTriangles = 0;
  this->pModelInfo.numNormals = 0;
  this->pModelInfo.numTexCoor = 0;

  this->pModelInfo.pVertices = NULL;
  this->pModelInfo.pTriangles = NULL;
  this->pModelInfo.pNormals = NULL;
  this->pModelInfo.pTexCoor = NULL;
}


/**
 * standard deconstructor
*/
Model::~Model()
{
  if( this->pModelInfo.pVertices != NULL)
    delete [] this->pModelInfo.pVertices;

  if( this->pModelInfo.pTriangles != NULL)
    delete [] this->pModelInfo.pTriangles;

  if( this->pModelInfo.pNormals != NULL)
    delete [] this->pModelInfo.pNormals;

  if( this->pModelInfo.pTexCoor != NULL)
    delete [] this->pModelInfo.pTexCoor;
}



void Model::draw() const
{
  const GLfloat* pVertices = NULL;
  const GLfloat* pNorm = NULL;

  glBegin(GL_TRIANGLES);
  for(unsigned int i = 0; i < this->pModelInfo.numTriangles; ++i)
    {
      //printf("int i = %i\n", i);
      pNorm = &this->pModelInfo.pNormals[this->pModelInfo.pTriangles[i].indexToNormals[0]];
      pVertices = &this->pModelInfo.pVertices[this->pModelInfo.pTriangles[i].indexToVertices[0]];
      glNormal3f(pNorm[0], pNorm[1], pNorm[2]);
      glVertex3f(pVertices[0], pVertices[1], pVertices[2]);

      pNorm = &this->pModelInfo.pNormals[this->pModelInfo.pTriangles[i].indexToNormals[1]];
      pVertices = &this->pModelInfo.pVertices[this->pModelInfo.pTriangles[i].indexToVertices[1]];
      glNormal3f(pNorm[0], pNorm[1], pNorm[2]);
      glVertex3f(pVertices[0], pVertices[1], pVertices[2]);

      pNorm = &this->pModelInfo.pNormals[this->pModelInfo.pTriangles[i].indexToNormals[2]];
      pVertices = &this->pModelInfo.pVertices[this->pModelInfo.pTriangles[i].indexToVertices[2]];
      glNormal3f(pNorm[0], pNorm[1], pNorm[2]);
      glVertex3f(pVertices[0], pVertices[1], pVertices[2]);

    }
  glEnd();
}


/**
 * adds a mounting point to the model
 * @param up up vector
 * @param forward forward vector
 * @param center center vector
 */
void Model::addMountPoint(const Vector& up, const Vector& forward, const Vector& center, const std::string& name)
{
  mountPointSkeleton mps;
  mps.up = up;
  mps.forward = forward;
  mps.center = center;
  mps.name = name;

  this->mountPoints.push_back(mps);
}
