/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "glgui_energywidgetvertical.h"

#include "multi_type.h"
#include <iostream>
#include "math.h"
#include "glgui_image.h"

namespace OrxGui
{
  /**
   * @brief standard constructor
   */
  GLGuiEnergyWidgetVertical::GLGuiEnergyWidgetVertical ()
  {
    this->_bar = new GLGuiBar();
    this->_valueText = new GLGuiText();
    this->_image = new GLGuiImage();

    this->setAbsDir2D(270);
    this->setBackgroundTexture(Texture());
    this->setBackgroundColor(Color(1,1,1,0));
    this->setBorderTop(10);
    this->setBorderLeft(10);
    this->setBorderRight(10);
    this->setBorderBottom(10);
    this->setWidgetSize(120,50);

    this->_bar->setParent2D(this);
    this->_bar->setBackgroundTexture(Texture());
    this->_bar->setBackgroundColor(Color(0,0,0,0));
    this->_bar->setForegroundTexture("maps/gui_element_background_faded.png");
    this->_bar->setForegroundColor(Color::green);
    this->_bar->setChangedValueColor(Color(1,0,0,0.2));
    this->_bar->setBorderTop(0);
    this->_bar->setBorderLeft(0);
    this->_bar->setBorderRight(0);
    this->_bar->setBorderBottom(0);
    this->_bar->setWidgetSize(100,30);
    //this->_bar.setRelCoor2D(borderLeft(), 0);
    this->_bar->setRelCoor2D(0,0);

    this->_image->setParent2D(this);
    this->_image->setBorderTop(0);
    this->_image->setBorderLeft(0);
    this->_image->setBorderRight(0);
    this->_image->setBorderBottom(0);
    this->_image->setWidgetSize(30,30);
    this->_image->setForegroundColor(Color(1,1,1,0.6));
    this->_image->setBackgroundColor(Color(1,1,1,0));
    this->_image->setBackgroundTexture(Texture());
    this->_image->loadImageFromFile("maps/evil-flower.png");
    //this->_image.setRelCoor2D(borderLeft(), borderTop() + this->_bar.getSizeX2D());
    this->_image->setRelCoor2D(0,0);
    this->_image->setRelDir2D(90);
    this->_image->setVisibility(true);


    this->_valueText->setParent2D(this->_bar);
    this->_valueText->setWidgetSize(100,20);
    //this->_valueText.setRelCoor2D(borderLeft(), borderTop() + this->_bar.getSizeX2D());
    this->_valueText->setAbsCoor2D(-15,-20);
    this->_valueText->setChangedTextColor(Color::white);
    this->_valueText->setForegroundColor(Color::white);
    this->_valueText->setBackgroundTexture(Texture());
    this->_valueText->setBackgroundColor(Color(0,0,0,0));
  }


  /**
   * @brief standard deconstructor
   */
  GLGuiEnergyWidgetVertical::~GLGuiEnergyWidgetVertical ()
  {
    if ( this->_valueText )
    {
      delete this->_valueText;
      this->_valueText = NULL;
    }
    
    if ( this->_image )
    {
      delete this->_image;
      this->_image = NULL;
    }
  }

  void GLGuiEnergyWidgetVertical::setMaximum(float max)
  {
    this->_bar->setMaximum(max);
  }

  void GLGuiEnergyWidgetVertical::setValue(float value)
  {
    MultiType val(value);
    //MultiType val(200.00);
    val.setType(MT_INT);


    this->_bar->setValue(value);
    this->_bar->setForegroundColor(Color::slerpHSVColor(Color::red, Color::green, value/this->_bar->maximum()));
    //this->_bar.setFrontColor(Color(1,1,1,1), true);
    this->_valueText->setText(val.getString());
    //this->_valueText.setText("asdfas");
  }

  void GLGuiEnergyWidgetVertical::setDisplayedImage(const std::string& imageName)
  {
    this->_image->loadImageFromFile(imageName);
  }

  void GLGuiEnergyWidgetVertical::resize()
  {
    Vector2D widgetSize = this->getSize2D();

    this->setBorderTop(widgetSize.y * 0.1);
    this->setBorderBottom(widgetSize.y * 0.1);
    this->setBorderLeft(widgetSize.x * 0.2);
    this->setBorderRight(widgetSize.x * 0.2);
    
    this->_bar->setWidgetSize(widgetSize.x * 0.8, widgetSize.y * 0.6);
    this->_image->setWidgetSize(widgetSize.y * 0.6, widgetSize.y * 0.6);
    this->_valueText->setWidgetSize(widgetSize.x* 0.8, widgetSize.y * 0.4);
  }


  void GLGuiEnergyWidgetVertical::showing()
  {
   
    this->_bar->show();
    this->_image->show();
    this->_valueText->show();
  }

  void GLGuiEnergyWidgetVertical::hiding()
  {
    this->_image->hide();
    this->_valueText->hide();
    this->_bar->hide();
  }
}
