/*!
 * @file hud.h
 * @brief Definition of the ingame HUD.
*/

#ifndef _HUD_H
#define _HUD_H

#include "element_2d.h"
#include "event_listener.h"
#include "glgui_box.h"
#include "elements/glgui_energywidgetvertical.h"


// FORWARD DECLARATION
class WeaponManager;
namespace OrxGui {
  class GLGuiWidget;
  class GLGuiNotifier;
  class GLGuiInputLine;
  class GLGuiRadar;
}

//! A class that renders a HUD (Heads Up Display for User Information).
class Hud : public Element2D, public EventListener
{
  ObjectListDeclaration(Hud);

public:
  Hud();
  virtual ~Hud();


  virtual void loadParams(const TiXmlElement* root);

  void notifyUser(const std::string& message);


  void setBackGround();
  void setEnergyWidget(OrxGui::GLGuiWidget* widget);
  void setShiledWidget(OrxGui::GLGuiWidget* widget);
  void setArmorWidget(OrxGui::GLGuiWidget* widget);
  inline OrxGui::GLGuiWidget* getEnergyWidget() {return this->energyWidget;};
  inline OrxGui::GLGuiWidget* getShieldWidget() {return this->shieldWidget;};
  inline OrxGui::GLGuiWidget* getArmorWidget() {return this->armorWidget;};

  void setWeaponManager(WeaponManager* weaponMan, WeaponManager* weaponManSec = NULL);
  inline void setRadarCenterNode(PNode* node) {this->radarCenterNode = node;};

  void addWeaponWidget(OrxGui::GLGuiWidget* widget);
  void removeWeaponWidget(OrxGui::GLGuiWidget* widget);

  OrxGui::GLGuiRadar* radar() const { return _radar; };

  void updateWeaponManager();
  //void clearWeaponManager();

  inline void setOverlayPercentage(int perc) 
  {
    if (perc > 100) perc = 100;
    else if (perc < 0) perc = 0;

    this->overlayPercentage = perc;
    updateResolution();
  };

  inline void setOverlayActive(bool b)
  {
    overlayActive = b;
    updateResolution();
  };

  void draw() const;
  virtual void process(const Event &event);


  private:
    void updateResolution();
    //void createShipValuesBox();

private:
  unsigned int             resX;
  unsigned int             resY;

  float                    travelZoneWidth; //the percentage of the screen, the player has got for his movements. should always be a value between 0 and 1;

  OrxGui::GLGuiWidget*     energyWidget;
  OrxGui::GLGuiWidget*     shieldWidget;
  OrxGui::GLGuiWidget*     armorWidget;

  OrxGui::GLGuiNotifier*   notifier;
  OrxGui::GLGuiInputLine*  inputLine;
  OrxGui::GLGuiRadar*      _radar;
  PNode*                   radarCenterNode;

  OrxGui::GLGuiWidget*     rightRect;
  OrxGui::GLGuiWidget*     leftRect;
  bool                     overlayActive;
  int                      overlayPercentage; //the percentage of the screen, the player has got for his movements. should always be a value between 0 and 1;

  WeaponManager*           weaponManager;
  WeaponManager*           weaponManagerSecondary;

  std::list<OrxGui::GLGuiEnergyWidgetVertical*> weaponsWidgetsPrim; //!< WeaponWidgets will be displayed one after another
  std::list<OrxGui::GLGuiEnergyWidgetVertical*> weaponsWidgetsSec;
};

#endif /* _HUD_H */
