/*!
 * @file rotor.h
 *  Rotor is a object which rotates around a given adress with a given speed
 */

#ifndef _ROTOR_H
#define _ROTOR_H

/* INCLUDES */
#include "world_entity.h"

/* FORWARD DECLARATION */

//! A Class to handle a Building
class Rotor : public WorldEntity
{
  ObjectListDeclaration(Rotor);
  public:
    Rotor(const TiXmlElement* root);

    virtual ~Rotor();
  
    virtual void loadParams(const TiXmlElement* root);
  
    void initRotation(float x, float y, float z);
    
    virtual void tick(float time);
  
  private:
    Vector              rotation;         //!< the rotation axis

};

#endif  /* _ROTOR_H */



