/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Knecht
   co-programmer: ...
*/

#include "rotor.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"



#include "class_id_DEPRECATED.h"
ObjectListDefinition(Rotor);
CREATE_FACTORY(Rotor);

/**
 *  initializes a rotating element from a XmlElement
*/
Rotor::Rotor(const TiXmlElement* root)
{
  this->registerObject(this, Rotor::_objectList);
  this->toList(OM_GROUP_00);
  
  //PRINTF(0)("loading Rotor");

  if (root != NULL)
    this->loadParams(root);
}

/**
 * loads the Settings of a Rotor from an XML-element.
 * @param root the XML-element to load the Rotor's properties from
 */
void Rotor::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "rotation", this, Rotor, initRotation);
}

/**
 * sets the rotation axis
 */
void Rotor::initRotation(float x, float y, float z)
{
     this->rotation = Vector(x,y,z);
}

/**
 * tick function
 */
void Rotor::tick(float dt)
{
     this->shiftDir(Quaternion(rotation.x*dt, Vector(1,0,0)) * Quaternion(rotation.y*dt, Vector(0,1,0)) * Quaternion(rotation.z*dt, Vector(0,0,1)));
     
}


/**
 *  default destructor
*/
Rotor::~Rotor()
{
}


