/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer:
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"


#include "test_entity.h"
#include "debug.h"
#include <iostream.h>
#include "state.h"
#include "shell_command.h"
#include "game_world_data.h"

#include "class_id_DEPRECATED.h"
ObjectListDefinition(TestEntity);
CREATE_FACTORY(TestEntity);



/**
 *
 */
TestEntity::TestEntity ()
{
  this->init();
}


SHELL_COMMAND(test, TestEntity,test);
SHELL_COMMAND(t2, TestEntity,t2);
SHELL_COMMAND(t3, TestEntity,t3);
SHELL_COMMAND(t4, TestEntity, t4);
SHELL_COMMAND(t5, TestEntity,t5);

/**
 *
 */
TestEntity::TestEntity(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);
}


/**
 *
 */
TestEntity::~TestEntity ()
{}


/**
 *
 */
void TestEntity::init()
{
  this->registerObject(this, TestEntity::_objectList);
  this->toList(OM_GROUP_00);

}

void TestEntity::test()
{
  CM= new cameraman();
  CM->createCam();
  //CM->moveCurrCam(-300, 0, 0);
  CM->moveCam(-300, 0, 0, 0);
}

void TestEntity::t2()
{
  CM->moveCurrCam(0, -300, 0);

}

void TestEntity::t3()
{

  CM->setCam(1);
}

void TestEntity::t4()
{
  cout << CM->cameras[1]->getAbsCoorX() << endl <<CM->cameras[1]->getAbsCoorY() << endl <<CM->cameras[1]->getAbsCoorZ() << endl << CM->cameras[1]->target->getAbsCoorX() << endl;
  CM->testCam();
  cout << CM->cameras[1]->getAbsCoorX() << endl <<CM->cameras[1]->getAbsCoorY() << endl <<CM->cameras[1]->getAbsCoorZ() << endl << CM->cameras[1]->target->getAbsCoorX() << endl;
}

void TestEntity::t5()
{
  CM->setCam(0);
}



/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void TestEntity::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}

void TestEntity::draw() const
{

}

/**
 *
 */
void TestEntity::tick (float time)
{

}


void  TestEntity::changeState (bool sta)
{

}
