/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli patrick@orxonox.net
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"


#include "mount_point.h"
#include "debug.h"
#include "state.h"


ObjectListDefinition(MountPoint);
CREATE_FACTORY(MountPoint);


/**
 * construct
 */
MountPoint::MountPoint (const Vector& up, const Vector& forward, const Vector& center, const std::string& name)
{

  this->_name = name;
  this->setAbsCoor( center);
  this->setAbsDir( Quaternion(forward, up));

  this->init();
}


/**
 * constructor
 * @param root the xml root element
 */
MountPoint::MountPoint(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);
}


/**
 * deconstructor
 */
MountPoint::~MountPoint ()
{}


/**
 * initializing function
 */
void MountPoint::init()
{
  this->registerObject(this, MountPoint::_objectList);
  this->toList(OM_GROUP_00);

  this->_mount = NULL;
}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void MountPoint::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}



/**
 * tick
 * @param time  time passed since the last tick
 */
void MountPoint::tick (float time)
{


}


/**
 * draw this entity
 */
void MountPoint::draw() const
{

}



/**
 *  function called to draw the mount point itself for debug purposes only
 */
void MountPoint::debugDraw() const
{

}


/**
 * adds an entity to this mount point
 * @param entity entity to be added
 */
void MountPoint::mount(WorldEntity* entity)
{
  this->_mount = entity;
}


/**
 * removes an entity from this mount point
 */
void MountPoint::unmount()
{
  this->_mount = NULL;
}

