
#ifndef _MOVEMENT_MODULE_H
#define _MOVEMENT_MODULE_H

#include "ai_module.h"
#include "player.h"
#include "playable.h"
//#include "npcs/npc_test.h"
class NPC2;


class MovementModule : public AIModule{

	public:
		MovementModule();
		inline MovementModule(NPC2* object){ this->myNPC=object; this->myWorldEntity=(WorldEntity*)object;}
		virtual ~MovementModule(){}
		virtual void process(float dt);

		static void setDistanceToPlayer(float newValue);
		static void setDistanceToNPC(float newValue);
		static void setMaxAccleartion(float newValue);
		static void setTestValue(float newValue);
		static void setTestValue2(float newValue);

	private:
		Vector myMovement;
		float myMaxAccleration;
		float myMaxSpeed;

		float getRadius(WorldEntity* object);

		static float maxAccleration;
		static float distanceToPlayer;
		static float distanceToNPC;
		static float testValue;
		static float testValue2;

		int tickCount;
		int randomFreq;
		Vector randomVector;
};

#endif /* _MOVEMENT_MODULE_H */
