/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Thomas Fahrni
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_AI

#include "movement_module.h"
#include "ai_engine.h"
#include "state.h"
#include "debug.h"
#include "player.h"
#include "playable.h"
#include "aabb.h"
#include "npcs/npc_test.h"

#include "shell_command.h"
SHELL_COMMAND(setDistanceToPlayer, MovementModule, setDistanceToPlayer);
SHELL_COMMAND(setDistanceToNPC, MovementModule, setDistanceToNPC);
SHELL_COMMAND(setMaxAccleartion, MovementModule, setMaxAccleartion);
SHELL_COMMAND(setTestValue, MovementModule, setTestValue);
SHELL_COMMAND(setTestValue2, MovementModule, setTestValue2);

float MovementModule::distanceToPlayer=15;
float MovementModule::distanceToNPC=2;
float MovementModule::maxAccleration=300.0f;
float MovementModule::testValue=2;
float MovementModule::testValue2=40;

void MovementModule::setDistanceToPlayer(float newValue){ distanceToPlayer=newValue; }
void MovementModule::setDistanceToNPC(float newValue){ distanceToNPC=newValue; }
void MovementModule::setMaxAccleartion(float newValue){ maxAccleration=newValue; }
void MovementModule::setTestValue(float newValue){ testValue=newValue; }
void MovementModule::setTestValue2(float newValue){ testValue2=newValue; }

MovementModule::MovementModule()
{
	tickCount=0;
	randomFreq=100;
}



float MovementModule::getRadius(WorldEntity* object)
{
	AABB* aabb = object->getModelAABB();
	if( aabb == NULL)return -1;

	float a = aabb->halfLength[0];
	float b = aabb->halfLength[1];
	float c = aabb->halfLength[2];

	if(a>b){
		return (c>a)?c:a;
	}else{
		return (c>b)?c:b;
	}
}


void MovementModule::process(float dt)
{
	if(myNPC == NULL)return;

	Vector tmpVector;
	float tmpFloat;
	Vector npcCollision;
	Vector playerCollision;
	bool autoRotate=true;
	target=enemyList->at(0);

	weight=1;
	speedMax=1000.0f;


	//get information about player
	Player* pl = State::getPlayer();
	if( pl == NULL)return;
	Vector playerPosition = pl->getPlayable()->getAbsCoor();
	float playerRadius=getRadius( pl->getPlayable() );


	//get information about myself
	Vector myPosition = myNPC->getAbsCoor();
	float myRadius = getRadius(myNPC);


	//anti player collision
	Vector vectorToPlayer = playerPosition - myPosition;

	tmpFloat=vectorToPlayer.len()-playerRadius-myRadius-distanceToPlayer;
	if(tmpFloat<0.1)tmpFloat=0.1;
	playerCollision=vectorToPlayer/(tmpFloat*tmpFloat)*(-1);


	//anti NPC collision
	for(ObjectList<WorldEntity>::const_iterator it = WorldEntity::objectList().begin(); it != WorldEntity::objectList().end(); ++it)
	{
		if(*it==myNPC)continue;

		tmpVector=myPosition-(*it)->getAbsCoor();
		tmpFloat=tmpVector.len()-myRadius-distanceToNPC-getRadius(*it);

		if(tmpFloat<0.1)tmpFloat=0.1;
		tmpVector=tmpVector/(tmpFloat*tmpFloat);

		npcCollision=npcCollision+tmpVector;
	}


	//random movement
	//randomFreq=testValue2;
	if(++tickCount>=randomFreq && movement.len()<60){
		tickCount=0;
		int x = (rand()%101)-50;			//-50-50
		int z = (rand()%101)-50;			//-50-50
		randomVector=Vector(x,0,z);
		randomFreq=(rand()%81)+70;			//70-150 Ticks
	}


	//calculate correction vector
	Vector vectorToDestination=destination-myPosition;

	Vector correction=		playerCollision*50*3
								+	npcCollision*50*3
								+	Vector(0,0,0)
								+	destinationMovement*2//-movement
								+	(vectorToDestination-movement)*3;

	if(movement.len()<testValue2){
	//if(testValue2){
		correction=correction + randomVector * testValue;
		autoRotate=false;
	}

	correction.y=0;


	//limit accleration
	float correctionLen=correction.len();
	if(correctionLen>maxAccleration*dt)correction=correction/correctionLen*maxAccleration*dt;
	movement+=correction;


	//limit speed
	float movementLen=movement.len();
	if(movementLen>speedMax)movement=movement/movementLen*speedMax;


	//move NPC...
	myNPC->shiftCoor(movement * dt);


	//rotate NPC
	Vector view;
	if(autoRotate){
		view = movement.cross( Vector(0,1,0) ).getNormalized();
	}else{
		view = target->getAbsCoor()-myPosition;
		view = view.cross( Vector(0,1,0) ).getNormalized();
	}
	myNPC->setAbsDirSoft( Quaternion( view, Vector(0,1,0)),3);

}


