/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Thomas Fahrni
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_AI
#include "ai_team.h"
#include "debug.h"

void AITeam::process(float dt)
{
	//int x;
	//int z;
	//Vector random;
	
	std::map<int,AISwarm*>::iterator it;
	for (it= swarms.begin(); it!= swarms.end(); it++ ){
	
		//x = 20*(rand()%10 + 1)-100;
		//z = 20*(rand()%10 + 1)-100;
		//random=Vector(x,0,z);
		
		it->second->setEnemyList(enemyList);
		if(enemyList->size()>0)
			it->second->setDestination(enemyList->at(0)->getAbsCoor());
		it->second->process(dt);
	}
}

void AITeam::addAI(int swarmNumber, AIModule* aiModule)
{
	std::pair<std::map<int,AISwarm*>::iterator,bool> p;
	AISwarm* newSwarm=new AISwarm();
	p=swarms.insert(std::make_pair(swarmNumber,newSwarm));
	if(!p.second)delete newSwarm;
	p.first->second->addAI(aiModule);
}

void AITeam::removeAI(int swarmNumber, AIModule* aiModule)
{
	std::map<int,AISwarm*>::iterator it = swarms.find(swarmNumber);
	if(it==swarms.end())return;
	it->second->removeAI(aiModule);
	if(it->second->getSwarmSize()==0){
		delete it->second;
		swarms.erase(it);
	}
}
