/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "point_gravity.h"




ObjectListDefinition(PointGravity);


/**
 *  standard constructor
   @todo this constructor is not jet implemented - do it
*/
PointGravity::PointGravity ()
{
  this->registerObject(this, PointGravity::_objectList);
}


/**
 *  standard deconstructor

*/
PointGravity::~PointGravity ()
{
  // delete what has to be deleted here
}

/**
 *  calculates the PointGravity on any point in space
 * @param data The Position of the Point in space to attache PointGravity to.
 * @returns The force.
*/
Vector PointGravity::calcForce(const Vector& data) const
{
  return (this->getAbsCoor() - data) * this->getMagnitude();
}


