/*!
 * @file synchronizeable_classid_list.h
 * @brief Definition of SynchronizeableClassIDList
*/

#ifndef _SYNCHRONIZEABLE_CLASSID_LIST_H
#define _SYNCHRONIZEABLE_CLASSID_LIST_H

#include "synchronizeable_var.h"

#include <map>
#include <string>

class SynchronizeableClassIDList : public SynchronizeableVar {

  public:
    SynchronizeableClassIDList( std::map< std::string, int > * ptrIn, std::map< std::string, int > * ptrOut, std::string name, int permission, int priority = 0 );
    virtual ~SynchronizeableClassIDList();

    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );


    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return false; };

    virtual int getSize();

    virtual int getSizeFromBuf( byte * buf, int maxLength );

    virtual void debug();

  private:
    std::map< std::string, int > * vPtrIn;       //!< pointer to data (read)
    std::map< std::string, int > * vPtrOut;      //!< pointer to data (write)

};

#endif /* _SYNCHRONIZEABLE_STRING_H */
