/*!
 * @file synchronizeable_int.h
 * @brief Definition of SynchronizeableInt
*/


#ifndef _SYNCHRONIZEABLE_CLASSID_H
#define _SYNCHRONIZEABLE_CLASSID_H

#include "synchronizeable_var.h"

class BaseObject;

class SynchronizeableClassID : public SynchronizeableVar {

  public:
    SynchronizeableClassID( BaseObject * ptrIn, std::string name, int permission, int priority = 0 );
    virtual ~SynchronizeableClassID();

    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );

    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; };

    virtual void debug();

  protected:
    BaseObject * vPtrIn;       //!< pointer to data (read)
    BaseObject * vPtrOut;      //!< pointer to data (write)


};

#endif /* _PROTO_CLASS_H */
