/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_classid.h"
#include "converter.h"

#include <cassert>

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableClassID::SynchronizeableClassID( BaseObject * ptrIn, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrIn, name, INTSIZE, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrIn;
}


/**
 * standard deconstructor
*/
SynchronizeableClassID::~SynchronizeableClassID ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableClassID::writeToBuf( byte * buf, int maxLength )
{
  int res = Converter::intToByteArray( vPtrIn->getClassID().id(), buf, maxLength );

  assert( res == INTSIZE );

  return res;
}

/**
 * read var data from byte buffer. actually this function does nothing but 
 * return INTSIZE
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableClassID::readFromBuf( byte * buf, int maxLength )
{
  return INTSIZE;
}


/**
 * print out variable value
 */
void SynchronizeableClassID::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: %d\n", name.c_str(), vPtrIn->getClassID().id() );
}

