
#ifndef _QUESTGUI_H
#define _QUESTGUI_H

#include "world_entity.h"
#include "glgui.h"
#include <vector>



class QuestGUI : public WorldEntity 
{

  ObjectListDeclaration(QuestGUI);
  
  public:
   QuestGUI (const TiXmlElement* root);
   virtual ~QuestGUI ();


   virtual void loadParams(const TiXmlElement* root = NULL);

   /** @param questName sets the name of this quest */
   inline void setQuestName(const std::string& questName) { this->questName = questName; }
   inline void setQuestDescription(const std::string& questDescription) { this->questDescription = questDescription; }
   inline void setQuestPicture(const std::string& questPicture) { this->questPicture = questPicture; }
   inline void setQuestOutline(const std::string& questOutline) { this->questOutline = questOutline; }
   void guiInit();

   
  private:
    std::string             questName;
    std::string             questDescription;
    std::string             questPicture;
    std::string             questOutline;
    
    OrxGui::GLGuiBox*       questBox;

    OrxGui::GLGuiBox*       currentlyOpened;

    OrxSound::SoundSource*  selectorSource;
};

#endif /* _QUESTGUI_H */
