

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Andreas Hejj

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "debug.h"
#include "quest_gui.h"

#include "event_handler.h"

#include "state.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "graphics_engine.h"
#include "camera.h"
#include "sound_engine.h"

#include "sound_source.h"

#include "glgui.h"
#include "menu/glgui_imagebutton.h"
#include "glgui_text.h"
#include <glgui_image.h>


#include "shell_command.h"




ObjectListDefinition(QuestGUI);

CREATE_FACTORY(QuestGUI);
SHELL_COMMAND(gui, QuestGUI, guiInit);
//SHELL_COMMAND(cancel, QuestGUI, guiDestruct); 


QuestGUI::QuestGUI(const TiXmlElement* root)
{
  this->registerObject(this, QuestGUI::_objectList);

  this->toList(OM_GROUP_00);
  
  this->questBox = NULL;

  this->currentlyOpened = NULL;
  

  if( root != NULL)
    this->loadParams(root);

}


/**
 * deconstructor
 */
QuestGUI::~QuestGUI () 
{
}




/**
 * loads the xml tagsthis->questDescription
 * @param root: root xml tag for this element
 */
void QuestGUI::loadParams(const TiXmlElement* root)
{
   WorldEntity::loadParams(root);
   
   LoadParam(root, "quest-name", this, QuestGUI, setQuestName)
       .describe("sets the name of a quest");
   LoadParam(root, "quest-description", this, QuestGUI, setQuestDescription)
       .describe("sets the description of a quest");
   LoadParam(root, "quest-picture", this, QuestGUI, setQuestPicture)
       .describe("sets the picture of a quest");
   LoadParam(root, "quest-outline", this, QuestGUI, setQuestOutline)
       .describe("sets the outline of a quiest");
   
}


/**
 * initializes the gui
 */
void QuestGUI::guiInit()
{  
  if (questBox == NULL)
  {
    this->questBox= new OrxGui::GLGuiBox();
    
    OrxGui::GLGuiBox* labelBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    //labelBox->setWidgetSize(100, 200);
    
    OrxGui::GLGuiText* questTxt = new OrxGui::GLGuiText();
    questTxt->setText(this->questDescription);
    labelBox->pack(questTxt);
    
    OrxGui::GLGuiImage* image = new OrxGui::GLGuiImage();
    image->setWidgetSize(100, 100);
    image->loadImageFromFile(questPicture);
    image->show();
    
    this->questBox->setAbsCoor2D(300, 40);
    labelBox->setRelCoor2D(300, 300);
    image->setRelCoor2D(0, 0);
    
    this->questBox->pack(image);
    this->questBox->pack(labelBox);
    this->questBox->showAll();
    
    OrxGui::GLGuiHandler::getInstance()->activate();
    OrxGui::GLGuiHandler::getInstance()->activateCursor();
  }
  else
  {
    OrxGui::GLGuiHandler::getInstance()->deactivate();
    OrxGui::GLGuiHandler::getInstance()->deactivateCursor();
    delete this->questBox;
    this->questBox = NULL;
  }
  
}




