/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "shader.h"

#include "compiler.h"
//#include <stdio.h>
#include <fstream>

#include "debug.h"



#ifndef PARSELINELENGTH
#define PARSELINELENGTH     512       //!< how many chars to read at once
#endif


ObjectListDefinition(Shader);

void Shader::Uniform::setV(unsigned int count, float* vv) const
{
	if (Shader::isSupported()) 
  switch (count)
  {
    case 1:
    glUniform1fv(this->uniform, 1, vv);
    break;
    case 2:
    glUniform2fv(this->uniform, 2, vv);
    break;
    case 3:
    glUniform3fv(this->uniform, 3, vv);
    break;
    case 4:
    glUniform4fv(this->uniform, 4, vv);
    break;
  }
}
void Shader::Uniform::setV(unsigned int count, int* vv) const
{
	if (Shader::isSupported()) 
  switch (count)
  {
    case 1:
    glUniform1iv(this->uniform, 1, vv);
    break;
    case 2:
    glUniform2iv(this->uniform, 2, vv);
    break;
    case 3:
    glUniform3iv(this->uniform, 3, vv);
    break;
    case 4:
    glUniform4iv(this->uniform, 4, vv);
    break;
  }
}



Shader::Shader()
  : data(NULL)
{

}

/**
 * standard constructor
*/
Shader::Shader (const std::string& vertexShaderFile, const std::string& fragmentShaderFile)
  : data(new ShaderData)
{
  if (!Shader::checkShaderAbility())
    PRINTF(2)("Your system does not support shaders\n");
  this->load(vertexShaderFile, fragmentShaderFile);

}

const Shader* Shader::storedShader = NULL;

void Shader::activateShader() const
{
  if (likely (this->getProgram() != 0))
  {
    glUseProgramObjectARB(this->getProgram());
    Shader::storedShader = this;
  }
}
void Shader::deactivateShader()
{
  if (storedShader != NULL)
    glUseProgramObjectARB(0);
  Shader::storedShader = NULL;
}

bool Shader::checkShaderAbility()
{
  if (GLEW_ARB_shader_objects &&
      GLEW_ARB_shading_language_100 &&
      GLEW_ARB_vertex_shader &&
      GLEW_ARB_fragment_shader)
    return true;
  else
    return false;
}


