/*!
 * @file resource_obj.h
 * @brief Contains the ResourceOBJ class, that handles the Resource-specific loading part of the OBJ.
 *
 */

#ifndef _RESOURCE_OBJ_H
#define _RESOURCE_OBJ_H

#include "util/loading/resource.h"
#include "obj/objModel.h"

class ResourceOBJ : public StaticModel, public Resources::Resource
{
public:
  ResourceOBJ(const std::string& imageName,
	      float scaling = 1.0f,
	      const Resources::KeepLevel& keepLevel = Resources::KeepLevel());
  static ResourceOBJ createFromString(const std::string& loadString,
				      const Resources::KeepLevel& keepLevel = Resources::KeepLevel());

private:
class OBJResourcePointer : public Resources::StorePointer
  {
  public:
    OBJResourcePointer(const std::string& loadString, const Resources::KeepLevel& keepLevel, const StaticModelData::Pointer& data);
    inline const StaticModelData::Pointer& ptr() const { return pointer; }
    virtual bool last() const { return pointer.count() == 1; }
private:
    StaticModelData::Pointer pointer;
  };

private:
  static Resources::tType<ResourceOBJ> type;
};


#endif /* _RESOURCE_OBJ_H */
