

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "attractor_mine.h"


#include "shader.h"
#include "state.h"
#include "debug.h"

#include "player.h"
#include "playable.h"

#include "loading/factory.h"
#include "loading/load_param.h"

#include "effects/explosion.h"

#include "class_id_DEPRECATED.h"
ObjectListDefinitionID(AttractorMine, CL_ATTRACTOR_MINE);
CREATE_FACTORY(AttractorMine);
#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(AttractorMine,
                        addMethod("setName", Executor1<BaseObject, lua_State*,const std::string&>(&BaseObject::setName))
                        //Coordinates
                        ->addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
                        ->addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
                        ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
                        ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
                       );




AttractorMine::AttractorMine(const TiXmlElement* root)
    : NPC(NULL)
{
  this->registerObject(this, AttractorMine::_objectList);

  this->toList(OM_GROUP_02);

  if ((float)rand()/RAND_MAX > .5f)
    this->loadModel("models/ships/noxon_battle_drone.obj", .3);
  else
    this->loadModel("models/ships/noxon_battle_drone.obj", .2);

  this->setDamage(30.0f);
  this->subscribeReaction(CoRe::CREngine::CR_OBJECT_DAMAGE, Playable::staticClassID());



  this->shader = NULL;
  //if (likely(Shader::checkShaderAbility()))
//    this->shader = Shader::getShader("shaders/toon.vert", "shaders/toon.frag");

  this->randomRotAxis = VECTOR_RAND(1);

  if (root != NULL)
    this->loadParams(root);
}


AttractorMine::~AttractorMine ()
{
}

void AttractorMine::loadParams(const TiXmlElement* root)
{
  NPC::loadParams(root);

}


void AttractorMine::destroy(WorldEntity* killer)
{
  Explosion::explode(this, Vector(10,10,10));
  this->toList(OM_DEAD);

}



/**
 *  the entity is drawn onto the screen with this function
 *
 * This is a central function of an entity: call it to let the entity painted to the screen.
 * Just override this function with whatever you want to be drawn.
 */
void AttractorMine::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];

  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);

  //   if (this->shader != NULL && this->shader != Shader::getActiveShader())
  //     shader->activateShader();

  this->getModel()->draw();
  //   shader->deactivateShader();


  /*  if (this->model)
      this->model->draw();*/
  glPopMatrix();
}


void AttractorMine::tick(float dt)
{
  PNode* attractNode = State::getPlayer()->getPlayable();
  if (attractNode != NULL)
  {
    if (this->distance(attractNode) < 80)
    {
      Vector dist = (attractNode->getAbsCoor() -  this->getAbsCoor());
      float distance = dist.len();
      this->velocity += dist * (( 250.0 - distance) / distance * dt);
    }
  }

  this->shiftCoor(this->velocity * dt);

  //  Vector direction = (State::getCameraTarget()->getAbsCoor() - this->getAbsCoor());

  //if (directin.len() < 100)
  //  this->shiftCoor(direction *dt * 5 * exp(-direction.len() / 30.0));
  this->shiftDir(Quaternion(.5 * dt, this->randomRotAxis));

}



