/*!
 * @file cr_object_damage.h
 *  Definition of a collision reaction: dealing damage to an object
 */

#ifndef _CR_PHYSICS_FULL_WALK_H
#define _CR_PHYSICS_FULL_WALK_H

#include "collision_reaction.h"

namespace CoRe
{

  class Collision;

  //! A class representing a reaction to a collision: dealing damage to an object
  class CRPhysicsFullWalk : public CollisionReaction
  {
    ObjectListDeclaration(CRPhysicsFullWalk);
  public:
    CRPhysicsFullWalk();
    virtual ~CRPhysicsFullWalk();

    virtual void reactToCollision(Collision* collision);
  };
}
#endif /* _CR_PHYSICS_FULL_WALK_H */
