/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION

#include "collision.h"
#include "collision_event.h"

#include "physics_interface.h"

#include "world_entity.h"
#include "cr_object_damage.h"

#include "debug.h"

namespace CoRe
{

  ObjectListDefinition(CRObjectDamage);
  /**
   *  standard constructor
   */
  CRObjectDamage::CRObjectDamage ()
      : CollisionReaction()
  {
    this->registerObject(this, CRObjectDamage::_objectList);
  }


  /**
   *  standard deconstructor
   */
  CRObjectDamage::~CRObjectDamage ()
  {}


  /**
   * caluculates and applys the reaction to a specific collision
   *  @param collision the collision
   */
  void CRObjectDamage::reactToCollision(Collision* collision)
  {
    float damage = 0.0f;

    PRINTF(0)("Dealing damage - Handling collision: %s vs %s\n",
              collision->getEntityA()->getClassCName(),
              collision->getEntityB()->getClassCName());

    // the collision damage been dealed by the entity
    if( collision->isEntityACollide())
    {
      damage = collision->getEntityB()->getDamage();
      collision->getEntityA()->hit(damage, collision->getEntityB());
      PRINTF(0)("Dealing damage - %f damage to %s \n", damage, collision->getEntityA()->getClassCName());
    }

    if( collision->isEntityBCollide())
    {
      damage = collision->getEntityA()->getDamage();
      collision->getEntityB()->hit(damage, collision->getEntityA());
      PRINTF(0)("Dealing damage - %f damage to %s \n", damage, collision->getEntityB()->getClassCName());
    }

    //   const std::vector<CollisionEvent*>* collisionEvents = &(collision->getCollisionEvents());
    //   std::vector<CollisionEvent*>::const_iterator it = collisionEvents->begin();
    //   for(; it != collisionEvents->end(); it++)
    //   {
    //     // go through the collisions and try to estimate the damage
    //     mass = (*it)->getEntityA()->getMass();
    //   }

  }

}
