/*!
 * @file collision_reaction.h
 *  Definition of a generic collision reaction
 */

#ifndef _COLLISION_REACTION_H
#define _COLLISION_REACTION_H

#include "base_object.h"

class WorldEntity;

namespace CoRe
{

  class Collision;

  //! A class representing a simple collision
  class CollisionReaction : public BaseObject
  {
    ObjectListDeclaration(CollisionReaction);
  public:
    CollisionReaction();
    virtual ~CollisionReaction();

    virtual void reactToCollision(Collision* collision) = 0;

    /** use this to do some collision offline calculations, only called for bContinuousPoll == true */
    inline bool isContinuousPoll() const { return this->bContinuousPoll; }

  private:
    bool                    bContinuousPoll;       //!< if true the collision rection function is also called, if there was no collision
  };

}
#endif /* _COLLISION_REACTION_H */
